#include "FS803A.h"
#include "af901x.h"
#include "define.h"

#define VERSION 10105             /*  Version 01.15 */

int RF_IF_FS803_X100[] =
{
    450,
    450,
    450,
    450,
    450,
    450,
    450,
    450,
    450,
    450,
    450,
    450,
    450,
    450,
    450,
    450,
    450,
    450,
    450,
    450,
    450
};
/*
**  RF Band cross-over frequencies
*/
static UData_t FS803_RF_Bands[] = 
{
     95000000L,     /*    0 ..  95 MHz: b1011      */
    180000000L,     /*   95 .. 180 MHz: b1010      */
    260000000L,     /*  180 .. 260 MHz: b1001      */
    335000000L,     /*  260 .. 335 MHz: b1000      */
    425000000L,     /*  335 .. 425 MHz: b0111      */
    490000000L,     /*  425 .. 490 MHz: b0110      */
    570000000L,     /*  490 .. 570 MHz: b0101      */
    645000000L,     /*  570 .. 645 MHz: b0100      */
    730000000L,     /*  645 .. 730 MHz: b0011      */
    810000000L      /*  730 .. 810 MHz: b0010      */
                    /*  810 ..     MHz: b0001      */
};

/*
** Constants used by the tuning algorithm
*/

struct MT_FIFZone_t;

struct MT_FIFZone_t
{
    SData_t         min_;
    SData_t         max_;
};

static UData_t Round_fLO(UData_t f_LO, UData_t f_LO_Step, UData_t f_ref)
{
    return f_ref * (f_LO / f_ref)
        + f_LO_Step * (((f_LO % f_ref) + (f_LO_Step / 2)) / f_LO_Step);
}

void MT_Sleep(Handle_t hUserData, 
              UData_t nMinDelayTime)
{
    mdelay((unsigned long) nMinDelayTime);
}

static UData_t umax(UData_t a, UData_t b)
{
    return (a >= b) ? a : b;
}

static UData_t gcd(UData_t u, UData_t v)
{
    UData_t r;

    while (v != 0)
    {
        r = u % v;
        u = v;
        v = r;
    }

    return u;
}

static SData_t RoundAwayFromZero(SData_t n, SData_t d)
{
    return (n<0) ? floor(n, d) : ceil(n, d);
}


static UData_t IsSpurInAdjTunerBand(UData_t bIsMyOutput,
                                    UData_t f1,
                                    UData_t f2,
                                    UData_t fOffset,
                                    UData_t fIFOut,
                                    UData_t fIFBW,
                                    UData_t fZIFBW,
                                    UData_t nMaxH,
                                    UData_t *fp,
                                    UData_t *fm)
{
    const UData_t fHalf_IFBW = fIFBW / 2;
    const UData_t fHalf_ZIFBW = fZIFBW / 2;

    /* Calculate a scale factor for all frequencies, so that our
       calculations all stay within 31 bits */
    const SData_t f_Scale = ((f1 + (fOffset + fIFOut + fHalf_IFBW) / nMaxH) / (2147483647 / nMaxH)) + 1;

	//const SData_t f_Scale = ((f1 + (fOffset + fIFOut + fHalf_IFBW) / nMaxH) / (MAX_UDATA/2 / nMaxH)) + 1;

    const SData_t _f1 = (SData_t) f1 / f_Scale;
    const SData_t _f2 = (SData_t) f2 / f_Scale;
    const SData_t _f3 = (SData_t) fOffset / f_Scale;

    const SData_t c = (SData_t) (fIFOut - fHalf_IFBW) / f_Scale;
    const SData_t d = (SData_t) (fIFOut + fHalf_IFBW) / f_Scale;
    const SData_t f = (SData_t) fHalf_ZIFBW / f_Scale;

    SData_t  ma, mb, mc, md, me, mf;

    SData_t  fp_ = 0;
    SData_t  fm_ = 0;
    SData_t  n;

    UData_t bSpurFound = 0;
    /*
    **  If the other tuner does not have an LO frequency defined,
    **  assume that we cannot interfere with it
    */
    if (f2 == 0)
        return 0;


    /* Check out all multiples of f1 from -nMaxH to +nMaxH */
    for (n = -(SData_t)nMaxH; n <= (SData_t)nMaxH; ++n)
    {
        md = (_f3 + d - n*_f1) / _f2;

        /* If # f2 harmonics > nMaxH, then no spurs present */
        if (md <= -(SData_t) nMaxH )
            break;

        ma = (_f3 - d - n*_f1) / _f2;
        if ((ma == md) || (ma >= (SData_t) (nMaxH)))
            continue;

        mc = (_f3 + c - n*_f1) / _f2;
        if (mc != md)
        {
            const SData_t m = (n<0) ? md : mc;
            const SData_t fspur = (n*_f1 + m*_f2 - _f3);
            bSpurFound = 1;
            fp_ = RoundAwayFromZero((d - fspur)* f_Scale, (bIsMyOutput ? n - 1 : n));
            fm_ = RoundAwayFromZero((fspur - c)* f_Scale, (bIsMyOutput ? n - 1 : n));
            break;
        }

        /* Location of Zero-IF-spur to be checked */
        mf = (_f3 + f - n*_f1) / _f2;
        me = (_f3 - f - n*_f1) / _f2;
        if (me != mf)
        {
            const SData_t m = (n<0) ? mf : me;
            const SData_t fspur = (n*_f1 + m*_f2 - _f3);
            bSpurFound = 1;
            fp_ = (SData_t) RoundAwayFromZero((f - fspur)* f_Scale, (bIsMyOutput ? n - 1 : n));
            fm_ = (SData_t) RoundAwayFromZero((fspur + f)* f_Scale, (bIsMyOutput ? n - 1 : n));
            break;
        }

        mb = (_f3 - c - n*_f1) / _f2;
        if (ma != mb)
        {
            const SData_t m = (n<0) ? mb : ma;
            const SData_t fspur = (n*_f1 + m*_f2 - _f3);
            bSpurFound = 1;
            fp_ = (SData_t) RoundAwayFromZero((-c - fspur)* f_Scale, (bIsMyOutput ? n - 1 : n));
            fm_ = (SData_t) RoundAwayFromZero((fspur +d)* f_Scale, (bIsMyOutput ? n - 1 : n));
            break;
        }
    }

    //  Verify that fm & fp are both positive
    //  Add one to ensure next 1st IF choice is not right on the edge
    if (fp_ < 0)
    {
        *fp = -fm_ + 1;
        *fm = -fp_ + 1;
    }
    else if (fp_ > 0)
    {
        *fp = fp_ + 1;
        *fm = fm_ + 1;
    }
    else
    {
        *fp = 1;
        *fm = abs(fm_) + 1;
    }

    return bSpurFound;
}
static UData_t IsSpurInBand(
    MT_AvoidSpursData_t* pAS_Info, 
    UData_t* fm, 
    UData_t* fp
)
{
    /*
    **  Calculate LO frequency settings.
    */
    UData_t n, n0;
    const UData_t f_LO1 = pAS_Info->f_LO1;
    const UData_t f_LO2 = pAS_Info->f_LO2;
    const UData_t d = pAS_Info->f_out + pAS_Info->f_out_bw/2;
    const UData_t c = d - pAS_Info->f_out_bw;
    const UData_t f = pAS_Info->f_zif_bw/2;
    //const UData_t f_Scale = (f_LO1 / (MAX_UDATA/2 / pAS_Info->maxH1)) + 1;
	const UData_t f_Scale = (f_LO1 / (2147483647/ pAS_Info->maxH1)) + 1;
    SData_t f_nsLO1, f_nsLO2;
    SData_t f_Spur;
    UData_t ma, mb, mc, md, me, mf;
    UData_t lo_gcd, gd_Scale, gc_Scale, gf_Scale;
#if MT_TUNER_CNT > 1
    UData_t index;

    MT_AvoidSpursData_t *adj;
#endif
    *fm = 0;

    /*
    ** For each edge (d, c & f), calculate a scale, based on the gcd
    ** of f_LO1, f_LO2 and the edge value.  Use the larger of this
    ** gcd-based scale factor or f_Scale.
    */
    lo_gcd = gcd(f_LO1, f_LO2);
    gd_Scale = umax((UData_t) gcd(lo_gcd, d), f_Scale);
    gc_Scale = umax((UData_t) gcd(lo_gcd, c), f_Scale);
    gf_Scale = umax((UData_t) gcd(lo_gcd, f), f_Scale);

    n0 = uceil(f_LO2 - d, f_LO1 - f_LO2);

    //  Check out all multiples of LO1 from n0 to m_maxLOSpurHarmonic
    for (n=n0; n<=pAS_Info->maxH1; ++n)
    {
        md = (n*(f_LO1/gd_Scale) - (d/gd_Scale)) / (f_LO2/gd_Scale);

        //  If # fLO2 harmonics > m_maxLOSpurHarmonic, then no spurs present
        if (md >= pAS_Info->maxH1)
            break;

        ma = (n*(f_LO1/gd_Scale) + (d/gd_Scale)) / (f_LO2/gd_Scale);

        //  If no spurs between +/- (f_out + f_IFBW/2), then try next harmonic
        if (md == ma)
            continue;

        mc = (n*(f_LO1/gc_Scale) - (c/gc_Scale)) / (f_LO2/gc_Scale);
        if (mc != md)
        {
            f_nsLO1 = (SData_t) (n*(f_LO1/gc_Scale));
            f_nsLO2 = (SData_t) (mc*(f_LO2/gc_Scale));
            f_Spur = (gc_Scale * (f_nsLO1 - f_nsLO2)) + n*(f_LO1 % gc_Scale) - mc*(f_LO2 % gc_Scale);

            *fp = ((f_Spur - (SData_t) c) / (mc - n)) + 1;
            *fm = (((SData_t) d - f_Spur) / (mc - n)) + 1;
            return 1;
        }

        //  Location of Zero-IF-spur to be checked
        me = (n*(f_LO1/gf_Scale) + (f/gf_Scale)) / (f_LO2/gf_Scale);
        mf = (n*(f_LO1/gf_Scale) - (f/gf_Scale)) / (f_LO2/gf_Scale);
        if (me != mf)
        {
            f_nsLO1 = n*(f_LO1/gf_Scale);
            f_nsLO2 = me*(f_LO2/gf_Scale);
            f_Spur = (gf_Scale * (f_nsLO1 - f_nsLO2)) + n*(f_LO1 % gf_Scale) - me*(f_LO2 % gf_Scale);

            *fp = ((f_Spur + (SData_t) f) / (me - n)) + 1;
            *fm = (((SData_t) f - f_Spur) / (me - n)) + 1;
            return 1;
        }

        mb = (n*(f_LO1/gc_Scale) + (c/gc_Scale)) / (f_LO2/gc_Scale);
        if (ma != mb)
        {
            f_nsLO1 = n*(f_LO1/gc_Scale);
            f_nsLO2 = ma*(f_LO2/gc_Scale);
            f_Spur = (gc_Scale * (f_nsLO1 - f_nsLO2)) + n*(f_LO1 % gc_Scale) - ma*(f_LO2 % gc_Scale);

            *fp = (((SData_t) d + f_Spur) / (ma - n)) + 1;
            *fm = (-(f_Spur + (SData_t) c) / (ma - n)) + 1;
            return 1;
        }
    }

#if MT_TUNER_CNT > 1
    //  If no spur found, see if there are more tuners on the same board
    for (index = 0; index < PDC->MT_TunerCount; ++index)
    {
        adj = PDC->MT_TunerList[index];
        if (pAS_Info == adj)    /* skip over our own data, don't process it */
            continue;

        //  Look for LO-related spurs from the adjacent tuner generated into my IF output
        if (IsSpurInAdjTunerBand(1,                   //  check my IF output
                                 pAS_Info->f_LO1,     //  my fLO1
                                 adj->f_LO1,          //  the other tuner's fLO1
                                 pAS_Info->f_LO2,     //  my fLO2
                                 pAS_Info->f_out,     //  my fOut
                                 pAS_Info->f_out_bw,  //  my output IF bandiwdth
                                 pAS_Info->f_zif_bw,  //  my Zero-IF bandwidth
                                 pAS_Info->maxH2,
                                 fp,                  //  minimum amount to move LO's positive
                                 fm))                 //  miminum amount to move LO's negative
            return 1;
        //  Look for LO-related spurs from my tuner generated into the adjacent tuner's IF output
        if (IsSpurInAdjTunerBand(0,             //  check his IF output
                                 pAS_Info->f_LO1,     //  my fLO1
                                 adj->f_LO1,          //  the other tuner's fLO1
                                 adj->f_LO2,          //  the other tuner's fLO2
                                 adj->f_out,          //  the other tuner's fOut
                                 adj->f_out_bw,       //  the other tuner's output IF bandiwdth
                                 pAS_Info->f_zif_bw,  //  the other tuner's Zero-IF bandwidth
                                 adj->maxH2,
                                 fp,                  //  minimum amount to move LO's positive
                                 fm))                 //  miminum amount to move LO's negative
            return 1;
    }
#endif
    // No spurs found
    return 0;
}
static struct MT_ExclZone_t* InsertNode(MT_AvoidSpursData_t* pAS_Info,
                                  struct MT_ExclZone_t* pPrevNode)
{
    struct MT_ExclZone_t* pNode;
    /*  Check for a node in the free list  */
    if (pAS_Info->freeZones != NULL)
    {
        /*  Use one from the free list  */
        pNode = pAS_Info->freeZones;
        pAS_Info->freeZones = pNode->next_;
    }
    else
    {
        /*  Grab a node from the array  */
        pNode = &pAS_Info->MT_ExclZones[pAS_Info->nZones];
    }

    if (pPrevNode != NULL)
    {
        pNode->next_ = pPrevNode->next_;
        pPrevNode->next_ = pNode;
    }
    else    /*  insert at the beginning of the list  */
    {
        pNode->next_ = pAS_Info->usedZones;
        pAS_Info->usedZones = pNode;
    }

    pAS_Info->nZones++;
    return pNode;
}


static struct MT_ExclZone_t* RemoveNode(MT_AvoidSpursData_t* pAS_Info,
                                  struct MT_ExclZone_t* pPrevNode,
                                  struct MT_ExclZone_t* pNodeToRemove)
{
    struct MT_ExclZone_t* pNext = pNodeToRemove->next_;

    /*  Make previous node point to the subsequent node  */
    if (pPrevNode != NULL)
        pPrevNode->next_ = pNext;

    /*  Add pNodeToRemove to the beginning of the freeZones  */
    pNodeToRemove->next_ = pAS_Info->freeZones;
    pAS_Info->freeZones = pNodeToRemove;

    /*  Decrement node count  */
    pAS_Info->nZones--;

    return pNext;
}

static UData_t CalcLO1Mult(UData_t *Div,
                           UData_t *FracN,
                           UData_t  f_LO,
                           UData_t  f_LO_Step,
                           UData_t  f_Ref)
{
    /*  Calculate the whole number portion of the divider */
    *Div = f_LO / f_Ref;

    /*  Calculate the numerator value (round to nearest f_LO_Step) */
    *FracN = (64 * (((f_LO % f_Ref) + (f_LO_Step / 2)) / f_LO_Step)+ (f_Ref / f_LO_Step / 2)) / (f_Ref / f_LO_Step);

    return (f_Ref * (*Div)) + (f_LO_Step * (*FracN));
}

static UData_t CalcLO2Mult(UData_t *Div,
                           UData_t *FracN,
                           UData_t  f_LO,
                           UData_t  f_LO_Step,
                           UData_t  f_Ref)
{
    //const UData_t FracN_Scale = (f_Ref / (MAX_UDATA >> 13)) + 1;
	const UData_t FracN_Scale = (f_Ref / (524287)) + 1;
    /*  Calculate the whole number portion of the divider */
    *Div = f_LO / f_Ref;

    /*  Calculate the numerator value (round to nearest f_LO_Step) */
    *FracN = (8191 * (((f_LO % f_Ref) + (f_LO_Step / 2)) / f_LO_Step) + (f_Ref / f_LO_Step / 2)) / (f_Ref / f_LO_Step);

    return (f_Ref * (*Div))
         + FracN_Scale * (((f_Ref / FracN_Scale) * (*FracN)) / 8191);

}

static UData_t IsValidHandle(FS803_Info_t* handle)
{
	return ((handle != NULL) && (handle->handle == handle)) ? 1 : 0;
}



Handle_t FS803_GetFS803Info(
    U8Data      ucSlaveDemod
)
{
    //return (&MT2060_Info[ucSlaveDemod]);
    return (&PDC->fc.tunerinfo.MT_Info.AvailFS803);
}
